const express = require('express');
const router = express.Router();
const db = require('../database/db');
const { route } = require('./student');

router.post('/add', (req, res) => {

    const {name} = req.body

    if (!name) {
        return res.status(400).send('Please fill all fields');
    }

    const query = 'INSERT INTO ljobcategory (name) VALUES (?)';
    const values = [name];

    db.query(query, values, (err, results) => {
        if (err) {
            console.error('Error inserting data:', err);
            return res.status(500).send('Server error');
        }

        return res.status(200).send('Data inserted successfully');
    });



});


router.get('/get', (req, res) => {
    const query = 'SELECT * FROM ljobcategory';

    db.query(query, (err, results) => {
        if (err) {
            console.error('Error getting data:', err);
            return res.status(500).send('Server error');
        }

        return res.status(200).send(results);
    });
});




router.delete('/delete/:id', (req, res) => {
    const { id } = req.params; // get id from URL params

    console.log(id);

    const query = 'DELETE FROM ljobcategory WHERE id = ?';
    const values = [id];

    db.query(query, values, (err, results) => {
        if (err) {
            console.error('Error deleting data:', err);
            return res.status(500).send('Server error');
        }

        return res.status(200).send('Data deleted successfully');
    });
});


module.exports = router;