const express = require('express');
const router = express.Router();
const db = require('../database/db');


router.get('/getAll', (req, res) => {

    const query = `SELECT * FROM fjobcategory`;

    db.query(query, (err, result) => {
        if (err) {
            res.status(500).send({ message: err.message });
        }
        res.json(result);
    });



})

router.post('/add', (req, res) => {
    const { name } = req.body;

    if (!name) {
        return res.status(400).send('Please fill all fields');
    }

    const query = 'INSERT INTO fjobcategory (name) VALUES (?)';
    const values = [name];

    db.query(query, values, (err, results) => {
        if (err) {
            console.error('Error inserting data:', err);
            return res.status(500).send('Server error');
        }

        return res.status(200).send('Data inserted successfully');
    });
});


//delete job category using id
router.delete('/delete/:id', (req, res) => {
    const { id } = req.params; // get id from URL params

    console.log(id);

    const query = 'DELETE FROM fjobcategory WHERE id = ?';
    const values = [id];

    db.query(query, values, (err, result) => {
        if (err) {
            console.error('Error deleting data:', err);
            return res.status(500).send('Server error');
        }

        return res.status(200).send('Data deleted successfully');
    });
});




module.exports = router;